IF EXISTS (SELECT 1 FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_TRILHO_PROD_NECESSIDADE]'))
	DROP VIEW [DBO].[V_TRILHO_PROD_NECESSIDADE]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[V_TRILHO_PROD_NECESSIDADE]
AS
SELECT     
	DT_MOV,
	N.CD_EMP,
	N.CD_CTR_DEPO,
	N.CD_FILIAL, 
	N.CD_PROD, 
	CASE WHEN NECESSIDADE > NECESSIDADE_FACEAMENTO AND NECESSIDADE > NECESSIDADE_FINANCIADO AND 
              NECESSIDADE > NECESSIDADE_LIMITADOR THEN NECESSIDADE 

	WHEN NECESSIDADE_FACEAMENTO > NECESSIDADE AND NECESSIDADE_FACEAMENTO > NECESSIDADE_FINANCIADO AND 
              NECESSIDADE_FACEAMENTO > NECESSIDADE_LIMITADOR THEN NECESSIDADE_FACEAMENTO 

	WHEN NECESSIDADE_FINANCIADO > NECESSIDADE_FACEAMENTO AND NECESSIDADE_FINANCIADO > NECESSIDADE AND 
              NECESSIDADE_FINANCIADO > NECESSIDADE_LIMITADOR THEN NECESSIDADE_FINANCIADO 

	WHEN NECESSIDADE_LIMITADOR > NECESSIDADE_FACEAMENTO AND NECESSIDADE_LIMITADOR > NECESSIDADE_FINANCIADO AND 
              NECESSIDADE_LIMITADOR > NECESSIDADE THEN NECESSIDADE_LIMITADOR 

	ELSE NECESSIDADE END AS NECESSIDADE,
	P.VLR_TABELA,
	N.CD_EXCESSO_MAQ
FROM        
	TRILHO_PROD_NECESSIDADE N
	INNER JOIN EST_PROD_PRECO P ON
	N.CD_EMP	= P.CD_EMP AND
	N.CD_FILIAL = P.CD_FILIAL AND
	N.CD_PROD	= P.CD_PROD
WHERE
	N.CD_EMP = 1
	AND DT_MOV = dbo.F_HOJE();
	

GO


